<?php
if (!isset($_GET['filename'])) {
    die("Filename not provided.");
}

$filename = basename($_GET['filename']); // Sanitize filename input
$filePath = "$filename";

if (!file_exists($filePath)) {
    die("File not found: $filePath");
}

$numbers = [];
$handle = fopen($filePath, "r");
if ($handle) {
    while (($data = fgetcsv($handle)) !== false) {
        if (isset($data[0])) {
            $numbers[] = ["msisdn" => ltrim($data[0], '0'), "status" => $data[1] ?? "0"];
        }
    }
    fclose($handle);
} else {
    die("Error opening file: $filePath");
}

$responseMessage = ""; // Variable to store the response message

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['msisdn'])) {
    $msisdn = $_POST['msisdn'];
    $code = $_POST['code'] ?? "";  // Capture the code input from POST
    $action = $_POST['action'];
    
    if ($action == "send_code") {
        $apiUrl = "https://apis.odibets.com/v3/account/code";
        $payload = json_encode([
            "msisdn" => $msisdn,
            "password" => "",
            "code" => "",
            "browser_name" => "Chrome",
            "browser_version" => "120.0.0.0",
            "browser_os" => "Android",
            "browser_device" => "",
            "browser_src" => "MOBILE",
            "ip_address" => "127.0.0.1"
        ]);
    } else if ($action == "reset_password") {
        // Ensure the verification code is provided
        if (empty($code)) {
            $responseMessage = "The verification code is required to reset the password.";
        } else {
            $apiUrl = "https://apis.odibets.com/v3/account/reset";
            $payload = json_encode([
                "msisdn" => $msisdn,
                "password" => "Year2025.",
                "code" => $code,  // Make sure the code is included
                "browser_name" => "Chrome",
                "browser_version" => "120.0.0.0",
                "browser_os" => "Android",
                "browser_device" => "",
                "browser_src" => "MOBILE",
                "ip_address" => "127.0.0.1"
            ]);
        }
    }
    
    if (!empty($payload)) {
        $ch = curl_init($apiUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Content-Type: application/json; charset=utf-8",
            "User-Agent: Dart/3.2 (dart:io)"
        ]);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
        
        $response = curl_exec($ch);
        curl_close($ch);
        
        // Display the exact response from the API
        $responseMessage = $response;
        
        // If the action was reset_password, and it was successful, update the status in the file
        if ($action == "reset_password" && strpos($response, "Account password changed.") !== false) {
            foreach ($numbers as &$num) {
                if ($num["msisdn"] == $msisdn) {
                    $num["status"] = "1"; // Mark as reset successful
                }
            }
            
            $handle = fopen($filePath, "w");
            foreach ($numbers as $num) {
                fputcsv($handle, [$num["msisdn"], $num["status"]]);
            }
            fclose($handle);
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Confirm Sent Codes</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body class="bg-light">
    <div class="container mt-2">
        <div class="card shadow-sm">
            <div class="card-body">
                <h2 class="text-center">Confirm Sent Codes</h2>
                
                <!-- Display Exact Response from the API -->
                <?php if (!empty($responseMessage)): ?>
                    <div class="alert alert-info">
                        <p><?php //echo htmlspecialchars($responseMessage);

                        $response = json_decode($responseMessage);
                        echo $response->status_description; ?></p>

                    </div>
                <?php endif; ?>

                <form method="POST">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Number</th>
                                    <?php if ($numbers && $numbers[0]['status'] != 'Reset Success'): ?>
                                        <th>Send Code</th>
                                        <th>Submit</th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($numbers as $num): ?>
                                <tr>
                                    <td><?php echo $num["msisdn"]; ?></td>
                                    
                                    <?php if ($num["status"] != "1"): ?>
                                        <!-- If reset has not been successful, show Send Code button, Code input, and Submit button -->
                                        <td>
                                            <form method="POST">
                                                <input type="hidden" name="msisdn" value="<?php echo $num["msisdn"]; ?>">
                                                <input type="hidden" name="action" value="send_code">
                                                <button type="submit" class="btn btn-warning">Request</button>
                                            </form>
                                        </td>
                                        <td>
                                            <form method="POST">
                                               <input type="hidden" name="msisdn" value="<?php echo $num["msisdn"]; ?>">
                                               <input type="hidden" name="action" value="reset_password">
                                               <input type="text" name="code" class="form-control" required>
                                               <br>
                                               <button type="submit" class="btn btn-primary">Submit</button>
                                             </form>

                                        </td>
                                    <?php else: ?>
                                        <!-- If reset was successful, show status message and hide other columns -->
                                        <td colspan="3" class="text-success">Password Reset Successful</td>
                                    <?php endif; ?>
                                    
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </form>

                <p><br><br><br><hr><a href="deposit.php?filename=D.csv">Proceed to deposit</a>
</p>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
