<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $numbers = $_POST['numbers'];
    $fileName = trim($_POST['file_name']);
    
    // Ensure filename is safe
    $fileName = preg_replace("/[^a-zA-Z0-9-_]/", "", $fileName);
    if (empty($fileName)) {
        $fileName = "default";
    }
    
    $filePath = "$fileName.csv";
    
    // Process numbers
    $numbersArray = explode("\n", $numbers);
    $cleanNumbers = array_map('trim', $numbersArray);
    $cleanNumbers = array_filter($cleanNumbers); // Remove empty lines
    
    // Open file for writing
    $file = fopen($filePath, "w");
    if ($file) {
        foreach ($cleanNumbers as $number) {
            fputcsv($file, [$number, 0]);
        }
        fclose($file);
        echo "<div class='alert alert-success text-center'>Numbers saved successfully to <strong>$filePath</strong></div>";
    } else {
        echo "<div class='alert alert-danger text-center'>Error saving file.</div>";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Save Phone Numbers</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body class="bg-light">
    <div class="container mt-2">
        <div class="card shadow-sm">
            <div class="card-body">
                <h2 class="text-center">Save Phone Numbers</h2>
                <form method="POST">
                    <div class="mb-3">
                        <label for="numbers" class="form-label">Enter Phone Numbers (one per line):</label>
                        <textarea name="numbers" class="form-control" rows="10" required></textarea>
                    </div>
                    <div class="mb-3">
                        <label for="file_name" class="form-label">File Name:</label>
                        <input type="text" name="file_name" class="form-control" required>
                    </div>
                    <div class="text-center">
                        <input type="submit" class="btn btn-primary" value="Save Numbers">
                    </div>
                </form>
                <p><br><br><br><hr><a href="reset.php?filename=D.csv">Proceed to reset</a>
</p>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS and dependencies -->
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.min.js"></script>
</body>
</html>
