<?php
// Ensure the filename is passed via GET
if (!isset($_GET['filename'])) {
    die("Filename not provided.");
}

$filename = basename($_GET['filename']); // Sanitize filename input
$filePath = "$filename";

// Check if file exists
if (!file_exists($filePath)) {
    die("File not found: $filePath");
}

$numbers = [];
$handle = fopen($filePath, "r");
if ($handle) {
    while (($data = fgetcsv($handle)) !== false) {
        if (isset($data[0])) {
            $numbers[] = ["msisdn" => ltrim($data[0], '0')]; // Read phone numbers
        }
    }
    fclose($handle);
} else {
    die("Error opening file: $filePath");
}

$responseMessage = ""; // Variable to store response message

// Function to generate a random IP address
function generateRandomIP() {
    return rand(1, 255) . '.' . rand(1, 255) . '.' . rand(1, 255) . '.' . rand(1, 255);
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['msisdn'])) {
    $msisdn = "254".$_POST['msisdn'];
    $sessionId = "cnclba96REqT-w5krVTLQ"; // Static session ID
    $ipAddress = generateRandomIP(); // Random IP address
    $amount = "99"; // Amount to be passed in request

    // Prepare payload for the POST request
    $payload = json_encode([
        "transactionDesc" => "MOBILE",
        "callbackURL" => "",
        "paybillNumber" => "290680",
        "browser_src" => "MOBILE",
        "profile_id" => "1",
        "phoneNumber" => $msisdn,  // Use phone number from the table
        "session_id" => $sessionId,
        "ip_address" => $ipAddress,
        "amount" => $amount
    ]);

    // API URL
    $apiUrl = "https://apis.odibets.com/push/stk";

    // Initialize cURL session
    $ch = curl_init($apiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "User-Agent: Dart/3.5 (dart:io)",
        "Content-Type: application/json; charset=utf-8",
        "Accept-Encoding: gzip",
        "Content-Length: " . strlen($payload)
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);

    // Execute cURL request
    $response = curl_exec($ch);

    // Check if the request was successful
    if (curl_errno($ch)) {
        $responseMessage = 'cURL Error: ' . curl_error($ch);
    } else {
        // Decode the JSON response
        $decodedResponse = json_decode($response, true);
        #echo $response;

        // Check for JSON decoding errors
        if (json_last_error() === JSON_ERROR_NONE) {
            // Example: Handle success or failure based on the response
            if (isset($decodedResponse['code']) && $decodedResponse['code'] === 'Success') {
                $responseMessage = "Success: " . $decodedResponse['statusDescription'];
            } else {
                $responseMessage = "Error: " . $decodedResponse['statusDescription'];
            }
        } else {
            $responseMessage = "Error decoding JSON response: " . json_last_error_msg();
        }
    }

    // Close cURL session
    curl_close($ch);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>STK Push Request</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body class="bg-light">
    <div class="container mt-5">
        <div class="card shadow-sm">
            <div class="card-body">
                <h2 class="text-center">Send STK Push Request</h2>
                
                <!-- Display API Response -->
                <?php if (!empty($responseMessage)): ?>
                    <div class="alert alert-info">
                        <pre><?php echo htmlspecialchars($responseMessage); ?></pre>
                    </div>
                <?php endif; ?>

                <form method="POST">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Number</th>
                                <th>Submit</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($numbers as $num): ?>
                            <tr>
                                <td><?php echo $num["msisdn"]; ?></td>
                                <td>
                                    <form method="POST">
                                        <input type="hidden" name="msisdn" value="<?php echo $num["msisdn"]; ?>">
                                        <button type="submit" class="btn btn-primary">Send Request</button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </form>
            </div>
        </div>
    </div>
</body>
</html>
